Attribute VB_Name = "CtrlCard"
'/*********************** Motion control module ********************
'     For developing an application system of great generality,
'   extensibility and convenientmaintenance easily and swiftly,
'   we envelop all the library functions by category basing on
'   the card function library
'*****************************************************************/
Public Result As Integer      'return

Const MAXAXIS = 4           'axis number

'*******************initial motion-card************************

'    this function is boot of using motion-card
'    Return<=0 fail to initial motion-card
'    Return>0  Succeed in initial motion-card

'*****************************************************
Public Function Init_Card() As Integer
       
    Result = adt8940a1_initial           'initial motion-card
    
    If Result <= 0 Then
     
       Init_Card = Result
       
       Exit Function
       
    End If
    
    For i = 1 To MAXAXIS
       
       set_command_pos 0, i, 0         'set logic pos as 0
       
       set_actual_pos 0, i, 0          'set real pos as 0
       
       set_startv 0, i, 1000           'set start-speed
       
       set_speed 0, i, 2000            'set motion-speed
       
       set_acc 0, i, 625               'set acceleration
     
    Next i
    
    Init_Card = Result
       
End Function

'/********************get version************************
'
'    get library version and hardware version
'
'    paralibVerlibrary version,hardwareVer - hardware version
'
'*********************************************************
Public Function Get_Version(libver As Double, hardwarever As Double) As Integer

    Dim ver As Integer
    
    ver = get_lib_version(0)
    
    libver = (ver)
    
    hardwarever = get_hardware_ver(0)
    
End Function

''/**********************set speed***********************
'
'    according as para,judge whether is constant-speed

'    set start-speed ,motion-speed and acceleration
'
'    paraaxis   -axis number
'
'          startv -start - speed
'
'          speed -motion - speed
'
'          Add -acceleration
'
'    Return=0 correctReturn=1 wrong

'*********************************************************
Public Function Setup_Speed(ByVal axis As Integer, ByVal startv As Long, ByVal speed As Long, ByVal add As Long, ByVal tacc As Double) As Integer

        If (startv - speed >= 0) Then
        
            Result = set_startv(0, axis, startv)
        
            set_speed 0, axis, startv
            
'            set_symmetry_speed 0, axis, startv, startv, tacc
            
        Else
        
            Result = set_startv(0, axis, startv)
        
            set_speed 0, axis, speed
        
            set_acc 0, axis, add / 125
            
'          set_symmetry_speed 0, axis, startv, speed, tacc
            
        End If
       
End Function

'/*********************single-axis motion**********************
'
'    drive one axis motion
'
'    para axis-axis numbervalue-pulse of motion
'
'    Return=0 correctReturn=1 wrong
'
'*******************************************************/
Public Function Axis_Pmove(ByVal axis As Integer, ByVal pulse As Long) As Integer
    
    Result = pmove(0, axis, pulse)
    
    Axis_Pmove = Rresult
    
End Function

'/*******************2-axis interpolation********************
'
'    any 2-axis linear interpolation
'
'    paraaxis1,axis2-axis numbervalue1,value2-pulse of interpolation
'
'    Return=0 correctReturn=1 wrong
'
'*******************************************************/
Public Function Interp_Move2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long) As Integer

    Result = inp_move2(0, axis1, axis2, pulse1, pulse2)
    
    Interp_Move2 = Result
    
End Function

'/*******************3-axis interpolation********************
'
'    any 3-axis linear interpolation
'
'    paraaxis1,axis2,axis3-axis numbervalue1,value2,value3-pulse of interpolation
'
'    Return=0 correctReturn=1 wrong
'
'*******************************************************/

Public Function Interp_Move3(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long) As Integer

    Result = inp_move3(0, axis1, axis2, axis3, pulse1, pulse2, pulse3)
    
    Interp_Move3 = Result
    
End Function


'/*******************4-axis interpolation****************************
'
'    4-axis interpolation motion
'
'    paravalue1,value2,value3,value4-pulse of interpolation
'
'    Return=0 correctReturn=1 wrong
'
'***********************************************************/
Public Function Interp_Move4(ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long) As Integer
    
    Result = inp_move4(0, pulse1, pulse2, pulse3, pulse4)
    
    Interp_Move4 = Result
    
End Function

'/*****************stop motion******************************
'
'    stop motion in the way of sudden or decelerate
'
'    paraaxis-axis numbermode-stop mode(0sudden stop, 1decelerate stop)
'
'    Return=0 correctReturn=1 wrong
'
'************************************************************/
Public Function StopRun(ByVal axis As Integer, ByVal mode As Integer) As Integer

    If mode = 0 Then
        
        Result = sudden_stop(0, axis)
        
    Else
    
        Result = dec_stop(0, axis)
    
    End If

End Function

'/*******************set position counter*******************************
'
'     set logic-pos or  real-pos
'
'     paraaxis-axis number,pos-the set value
'           mode 0set logic pos,non 0set real pos
'
'      Return=0 correctReturn=1 wrong
'****************************************************************/
Public Function Setup_Pos(ByVal axis As Integer, ByVal pos As Long, ByVal mode As Integer) As Integer

    If mode = 0 Then
    
        Result = set_command_pos(0, axis, pos)
        
    Else
    
        Result = set_actual_pos(0, axis, pos)
        
    End If
    
End Function

'/*****************get information of motion*****************************
'
'    get logical-pos,actual-pos and motion-speed
'
'    paraaxis-axis number,LogPos-logic pos,ActPos-real pos,Speed-motion speed
'
'    Return=0 correctReturn=1 wrong
'
'************************************************************/
Public Function Get_CurrentInf(ByVal axis As Integer, LogPos As Long, actpos As Long, speed As Long) As Integer

    Result = get_command_pos(0, axis, LogPos)
    
    get_actual_pos 0, axis, actpos
    
    get_speed 0, axis, speed
    
    Get_CurrentInf = Result
    
End Function


'/*****************get status of motion**************************
'
'    get status of single-axis motion or interpolation
'
'    paraaxis-axis numbervalue-Indicator of motion status(0Drive completed,Non-0: Drive in process)
'
'          mode(0-single-axis motion1interpolation)
'
'    Return=0 correctReturn=1 wrong
'
'************************************************************/
Public Function Get_MoveStatus(ByVal axis As Integer, value As Long, ByVal mode As Integer) As Integer

    If mode = 0 Then
    
        GetMove_Status = get_status(0, axis, value)
        
    Else
    
        GetMove_Status = get_inp_status(0, value)
        
    End If
    
End Function

'/***********************read input*******************************
'
'     read status of input
'
'     paranumber-input port(0 ~ 39)
'
'     Return0  low level1  high level-1  error
'
'****************************************************************/
Public Function Read_Input(ByVal number As Integer) As Integer
    
    Read_Input = read_bit(0, number)
    
End Function

'/*********************output******************************
'
'    set status 0f output
'
'    para number-output port(0 ~ 15),value 0-low level1high level
'
'    Return=0 correctReturn=1 wrong
'****************************************************************/
Public Function Write_Output(ByVal number As Integer, ByVal value As Integer) As Integer

    Write_Output = write_bit(0, number, value)
    
End Function


'/********************set pulse mode**********************
'
'    set the mode of pulse output
'
'    paraaxis-axis number value-pulse mode 0pulse+pulse 1pulse + direction
'
'     Return=0 correctReturn=1 wrong
'
'    Default mode: Pulse + direction, with positive logic pulse
'
'    and positive logic direction input signal
'
'*********************************************************/
Public Function Setup_PulseMode(ByVal axis As Integer, ByVal value As Integer) As Integer

    Setup_PulseMode = set_pulse_mode(0, axis, value, 0, 0)
    
End Function


'/********************set nLMT mode**********************
'
'   set the mode of nLMT signal input along positive/ negative direction
'   para axisaxis number
'          value1   0 - positive limit effective     1: positive limit ineffective
'          value2   0: negative limit effective      1: negative limit ineffective
'          logic    0: low level effective           1: high level ineffective
'   Default mode: Apply positive and negative limits with low level
'
'   Return   0Correct                  1 Wrong
'  *********************************************************/
Public Function Setup_LimitMode(ByVal axis As Integer, ByVal value1 As Integer, ByVal value2 As Integer, ByVal logic As Integer) As Integer

    Setup_LimitMode = set_limit_mode(0, axis, value1, value2, logic)
    
End Function

'
'/********************set stop0 mode**********************
'
'   Set mode of stop0 input signal
'   para axisaxis number
'          value   0ineffective  1effective
'          logic   0low level effective  1high level effective
'   Defaule:     ineffective
'   Return   0Correct                  1 Wrong
'  *********************************************************/
Public Function Setup_Stop0Mode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_Stop0Mode = set_stop0_mode(0, axis, value, logic)
    
End Function


'/********************set stop1 mode**********************
'
'   Set mode of stop1 input signal
'   para axisaxis number
'          value   0ineffective  1effective
'          logic   0low level effective  1high level effective
'   Defaule:     ineffective
'   Return   0Correct                  1 Wrong
'  *********************************************************/
Public Function Setup_Stop1Mode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_Stop1Mode = set_stop1_mode(0, axis, value, logic)
    
End Function

'/********************set hardware-stop mode **********************
'
'   set mode whether Hardware stop is effective,if hareware-version is 1 ,
'   motion-card havn't this function
'   para value   0ineffective  1effective
'          logic   0low level effective  1high level effective
'   Defaule:     ineffective
'   Return   0Correct                  1 Wrong
'   Hardware stop signals are assigned to use the 34 pin at the P3 terminal panel (IN31)
'  *********************************************************/

Public Function Setup_HardStop(ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_HardStop = set_suddenstop_mode(0, value, logic)
    
End Function

'/********************set delay**********************
'
'   set the time of delay,if hareware-version is 1 ,motion-card havn't this function
'   para time - time of delay(unit is us)
'   Return   0Correct                  1 Wrong
'
'  *********************************************************/

Public Function Setup_Delay(ByVal time As Long) As Integer

    Setup_Delay = set_delay_time(0, time * 8)
    
End Function

'/********************get delay status **********************
'
'   get the status of delay ,if hareware-version is 1 ,motion-card havn't this function
'
'   Return   0: delay stop          1: delay in process
'
'  *********************************************************/

Public Function Get_DelayStatus() As Integer

    Get_DelayStatus = get_delay_status(0)
    
End Function


'/************ Symmetrical relative movement of single-axis ***************
'function: Refer to the current position and perform quantitative movement in the symmetrical
'acceleration/deceleration
'para:
'     axis---axis number
'     pulse --pulse
'     lspd--- Low speed
'     hspd--- High speed
'     tacc--- Time of acceleration (Unit: sec)
'return value 0correct 1wrong
'*******************************************************************/
Public Function Sym_RelativeMove(ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double) As Integer

    Result = symmetry_relative_move(0, axis, pulse, lspd, hspd, tacc)

    Symmetry_RelativeMove = Result
End Function

'/************** Symmetrical absolute movement of single-axis ***********
'function: Refer to the position of zero point and perform quantitative movement in the symmetrical
'acceleration/deceleration
'para:
'     axis ---axis number
'     pulse --pulse
'     lspd --- Low speed
'     hspd --- High speed
'     tacc--- Time of acceleration (Unit: sec)
'return value 0: correct 1: wrong
'*******************************************************************/
Public Function Sym_AbsoluteMove(ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double) As Integer
    
    Result = symmetry_absolute_move(0, axis, pulse, lspd, hspd, tacc)
    
    Symmetry_AbsoluteMove = Result
    
End Function

'/***** Relative movement of two-axis symmetrical linear interpolation ********
'function: Refer to current position and perform linear interpolation in symmetrical
'acceleration/deceleration
'para:
'     axis1---axis number1
'     axis2---axis number2
'     pulse1-- pulse 1
'     pulse2-- pulse 2
'     lspd --- Low speed
'     hspd --- High speed
'     tacc--- Time of acceleration (Unit: sec)
'return value 0correct 1wrong
'******************************************************************/
Public Function Sym_RelativeLine2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double) As Integer

    Result = symmetry_relative_line2(0, axis1, axis2, pulse1, pulse2, lspd, hspd, tacc)

    Symmetry_RelativeLine2 = Result

End Function

'/****** Two axes symmetric linear interpolation absolute moving ********
'function: Refer to the position of zero point and perform linear interpolation in symmetrical
'acceleration/deceleration
'para:
'     axis1---axis number1
'     axis2---axis number2
'     pulse1pulse of axis 1
'     pulse2-- pulse of axis 2
'     lspd --- Low speed
'     hspd --- High speed
'     tacc--- Time of acceleration (Unit: sec)
'return value 0correct 1wrong
'******************************************************************/
Public Function Sym_AbsoluteLine2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double) As Integer
    
    Result = symmetry_absolute_line2(0, axis1, axis2, pulse1, pulse2, lspd, hspd, tacc)
    
    Symmetry_AbsoluteLine2 = Result

End Function

'/***** Three axes symmetric linear interpolation relative moving ******
'function: Refer to current position and perform linear interpolation in symmetric
'acceleration/deceleration
'para:
'     axis1---axis number1
'     axis2---axis number2
'     axis3---axis number3
'     pulse1-- pulse of axis 1
'     pulse2-- pulse of axis 2
'     pulse3-- pulse of axis 3
'     lspd --- Low speed
'     hspd --- High speed
'     tacc--- Time of acceleration (Unit: sec)
'return value 0correct 1wrong
'******************************************************************/
Public Function Sym_RelativeLine3(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double) As Integer

    Result = symmetry_relative_line3(0, axis1, axis2, axis3, pulse1, pulse2, pulse3, lspd, hspd, tacc)

    Symmetry_RelativeLine3 = Result

End Function

'/******Three axes symmetric linear interpolation absolute moving **********
'function: Refer to the position of zero point and perform linear interpolation in symmetric
'acceleration/deceleration.
'para:
'     axis1---axis number1
'     axis2---axis number2
'     axis3---axis number3
'     pulse1-- pulse of axis 1
'     pulse2-- pulse of axis 2
'     pulse3-- pulse of axis 3
'     lspd --- Low speed
'     hspd --- High speed
'     tacc--- Time of acceleration (Unit: sec)
'return value 0correct 1wrong
'******************************************************************/
Public Function Sym_AbsoluteLine3(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double) As Integer

    Result = symmetry_absolute_line3(0, axis1, axis2, axis3, pulse1, pulse2, pulse3, lspd, hspd, tacc)

    Symmetry_AbsoluteLine3 = Result

End Function

'/***** Four axes symmetric linear interpolation relative moving ******
'function: Refer to current position and perform linear interpolation in symmetric
'acceleration/deceleration
'para:
'     pulse1-- pulse of axis 1
'     pulse2-- pulse of axis 2
'     pulse3-- pulse of axis 3
'     pulse4-- pulse of axis 4
'     lspd --- Low speed
'     hspd --- High speed
'     tacc--- Time of acceleration (Unit: sec)
'return value 0correct 1wrong
'******************************************************************/
Public Function Sym_RelativeLine4(ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double) As Integer

    Result = symmetry_relative_line4(0, pulse1, pulse2, pulse3, pulse4, lspd, hspd, tacc)

    Symmetry_RelativeLine4 = Result

End Function
'/******Four axes symmetric linear interpolation absolute moving **********
'function: Refer to the position of zero point and perform linear interpolation in symmetric
'acceleration/deceleration.
'para:
'     pulse1-- pulse of axis 1
'     pulse2-- pulse of axis 2
'     pulse3-- pulse of axis 3
'     pulse4-- pulse of axis 4
'     lspd --- Low speed
'     hspd --- High speed
'     tacc--- Time of acceleration (Unit: sec)
'return value 0correct 1wrong
'******************************************************************/
Public Function Sym_AbsoluteLine4(ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double) As Integer

    Result = symmetry_absolute_line4(0, pulse1, pulse2, pulse3, pulse4, lspd, hspd, tacc)

    Symmetry_AbsoluteLine4 = Result

End Function


'/************ Quantitative drive function of external signal *******
'function: Quantitative drive function of external signal
'para:
'     cardno    card number
'     axis      axis number
'     pulse pulse
'Return 0Correct 1Wrong
'******************************************************************/
Public Function Manu_Pmove(ByVal axis As Integer, ByVal pulse As Long) As Integer

    Result = manual_pmove(0, axis, pulse)
    
    Manu_Pmove = Result
    
End Function

'/************* Continuous drive function of external signal ********
'function: Continuous drive function of external signal
'para:
'     cardno   card number
'     axis     axis number
'Return 0Correct 1Wrong
'******************************************************************/
Public Function Manu_Continue(ByVal axis As Integer) As Integer

    Result = manual_continue(0, axis)
    
    Manu_Continue = Result

End Function

'/*********** Shut down the enabling of external signal drive ********
'function: Shut down the enabling of external signal drive
'para:
'     cardno    card number
'     axis      axis number
'Return 0Correct 1Wrong
'******************************************************************/
Public Function Disable_Manu(ByVal axis As Integer) As Integer

   Result = manual_disable(0, axis)

   Disable_Manu = Result

End Function

'/*********************** set lockmode ***************************
'function:lock the logical position and real position for all axis
'para:
'     axisreference axis
'     mode--set lock mode    |0:inefficacy
'                            |1:efficiency
'     regiregister mode    |0:logical position
'                            |1:real position
'     logicallevel signal  |0: from high to low
'                            |1:from low to high
'retutrn 0: correct 1: wrong
'Note: Use IN signal of specific axis as the trigger signal
'****************************************************************/
Public Function Get_LockStatus(ByVal axis As Integer, status As Integer) As Integer

    Result = get_lock_status(0, axis, status)
 
    Get_LockStatus = Result
    
End Function

'/******************** get synchronous action state ***********************
'function:get synchronous action state
'para:
'     axis      axis number
'     status  0|haven't run synchronous
'               1|run synchronous
'retutrn 0: correct 1: wrong
'Note: This function could tell whether the position lock has been executed
'****************************************************************************/
Public Function Setup_LockPosition(ByVal axis As Integer, ByVal mode As Integer, ByVal regi As Integer, ByVal logical As Integer) As Integer
    
    Result = set_lock_position(0, axis, mode, regi, logical)
    
    Setup_LockPosition = Result
    
End Function

'/**********************get lock position************************
'Function: Get the locked position
'para:
'     axis      axis number
'     pos lock position
'Return 0Correct 1Wrong
'******************************************************************/
Public Function Get_LockPosition(ByVal axis As Integer, pos As Long) As Integer

    Result = get_lock_position(0, axis, pos)
    
    Get_LockPosition = Result
    
End Function

'/**********************clean lock position************************
'Function: Clean the locked position
'para:
'     axis      axis number
'Return 0Correct 1Wrong
'******************************************************************/
Public Function Clr_LockStatus(ByVal axis As Integer) As Integer

    Result = clr_lock_status(0, axis)
    
    Clr_LockStatus = Result
    
End Function


